

export class ContractListWidget {

	ezTpl = null;
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.exportContracts" class="fa fa-file-export"></a>
				
				<a href="{{appUrl('/contracts/edit/')}}" class="fa fa-plus"></a>
			</div>
			<h1>Contracten</h1>
		</div>
		
			
		<form id="frmContractSearch" method="get">
			<div class="chk-search-status">
				<ez-checkbox name="st_open"        label="Open"                 value="open"></ez-checkbox>
				<ez-checkbox name="st_negotiation" label="In onderhandeling"    value="negotiation"></ez-checkbox>
				<ez-checkbox name="st_reviewal"    label="Ter beoordeling"      value="reviewal"></ez-checkbox>
				<ez-checkbox name="st_accepted"    label="Geaccepteerd"         value="accepted"></ez-checkbox>
				<ez-checkbox name="st_active"      label="Actief"               value="active"></ez-checkbox>
				<ez-checkbox name="st_expiring"    label="Aflopend"             value="expiring"></ez-checkbox>
				<ez-checkbox name="st_terminated"  label="Beëindigd"            value="terminated"></ez-checkbox>
			</div>
			
			<div class="clear"></div>
			
			<input type="text" class="top-q" placeholder="Zoeken: relatie, contractnaam, ..." />
		</form>

		<div id="ctresults" ez-subtemplate="cresults">
			<div ez-if="contracts == null">
				Loading...
			</div>
			<div ez-if="contracts != null">
				<table class="table">
					<thead>
						<tr>
							<th>#</th>
							<th>Contract</th>
							<th>Relatie</th>
							<th>Waarde</th>
							<th>Contract type</th>
							<th>Startdatum</th>
							<th>Einddatum</th>
							<th>Verlengdatum</th>
							<th>Status</th>
							<th></th>
						</tr>
					</thead>
					<tbody>
						<tr ez-forme="contracts" ez-item="c" [onclick]="widget.editContract" class="pointer" contract-id="{{c.contractId}}">
							<td>{{c.contractId}}</td>
							<td>{{c.name}}</td>
							<td>{{c.customerName ?? ''}}</td>
							<td>
								{{c.amountDescription}}
							</td>
							<td>
								{{c.contractTypeName}}
							</td>
							<td>
								{{ c.startDate ? format_date(c.startDate, {dmy: true}) : '' }}
							</td>
							<td>
								{{ c.endDate ? format_date(c.endDate, {dmy: true}) : '' }}
							</td>
							<td>
								{{ c.renewalDate ? format_date(c.renewalDate, {dmy: true}) : ''}}
							</td>
							<td>
								{{_('contract_status.'+c.status)}}
							</td>
							<td class="actions">
								<a href="{{appUrl('/contracts/edit/?id='+c.contractId)}}" class="fa fa-pencil"></a>
							</td>
						</tr>
					</tbody>
						<tr ez-if="contracts.length == 0">
							<td colspan="100%" class="no-results">Geen resultaten gevonden</td>
						</tr>
				</table>
				
				<ez-pager></ez-pager>
			</div>
		</div>
	`;
	
	pageNo = 0;
	
	
	
	init(e) {
		this.ezTpl = new EzTemplate( e );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('contracts', null);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		$('.top-q').focus();
		
		this.loadState();
		
		$('#frmContractSearch').find('input[type=checkbox], input[type=text]').on('change', function() {
			this.pageNo = 0;
			this.loadContracts();
		}.bind(this));

		
		$('#frmContractSearch').find('input[type=checkbox]').on('change', function() {
			this.saveState();
		}.bind(this));

	}
	
	
	
	editContract(evt, tr) {
		let cid = tr.getAttribute('contract-id');
		
		gotoRoute( '/contracts/edit/?id='+cid );
	}
	
	loadContracts() {
		let data = {};
		
		data.pageNo = this.pageNo;
		
		data.q = $.trim( $('.top-q').val() );
		data.st_open        = $('input[name=st_open]').prop('checked') ? 1 : 0;
		data.st_negotiation = $('input[name=st_negotiation]').prop('checked') ? 1 : 0;
		data.st_reviewal    = $('input[name=st_reviewal]').prop('checked') ? 1 : 0;
		data.st_accepted    = $('input[name=st_accepted]').prop('checked') ? 1 : 0;
		data.st_active      = $('input[name=st_active]').prop('checked') ? 1 : 0;
		data.st_expiring    = $('input[name=st_expiring]').prop('checked') ? 1 : 0;
		data.st_terminated  = $('input[name=st_terminated]').prop('checked') ? 1 : 0;
		
		
		postUrl('/service/contracts/list.do'
			, data
		).then(async function(e) {
			let json = await e.json();
			
			console.log('json', json);
			
			
//			if (json.error) {
//				return showErrorWidget( json );
//			}

			let subtpl = $('[ez-subtemplate="cresults"]');
			if (subtpl.length == 0) {
				console.error('ContractList.loadContracts, subtemplate cresults not found');
				return;
			}			

			let tpl = subtpl.get(0).eztemplate;

			tpl.setObject('widget', this);
			
			tpl.setVar('contracts', json.contracts);
			tpl.setVar('response', json);
			
			tpl.render();
		}.bind(this));
	}
	
	
	selectPage(pageNo) {
		this.pageNo = pageNo;
		this.loadContracts();
	}
	
	
	exportContracts() {
		window.location = '/service/contracts/list.do?a=export';
	}
	
	
	saveState() {
		let s = {};
		s.st_open        = $('input[name=st_open]').prop('checked')  ? 1 : 0;
		s.st_negotiation = $('input[name=st_negotiation]').prop('checked')  ? 1 : 0;
		s.st_reviewal    = $('input[name=st_reviewal]').prop('checked')  ? 1 : 0;
		s.st_accepted    = $('input[name=st_accepted]').prop('checked')  ? 1 : 0;
		s.st_active      = $('input[name=st_active]').prop('checked')  ? 1 : 0;
		s.st_expiring    = $('input[name=st_expiring]').prop('checked')  ? 1 : 0;
		s.st_terminated  = $('input[name=st_terminated]').prop('checked')  ? 1 : 0;
		
		postUrl( '/service/state.do', {
			a: 'save',
			name: 'contract-search-settings',
			key: '1',
			data: JSON.stringify( s )
		});
	}
	
	
	loadState() {
		postUrl( '/service/state.do', {
			a: 'load',
			name: 'contract-search-settings',
			key: '1'
		}).then( async function(e) {
			let json = await e.json();
			
			let checkCount = 0;
			if (json && json.success && json.data) {
				let settings = JSON.parse( json.data );
				if (settings) {
					for(let i in settings) {
						if ( settings[i] && $('input[name='+i+']').length > 0 ) {
							$('input[name='+i+']').prop('checked', true);
							checkCount++;
						}
					}
				}
			}
			
//			if (checkCount == 0) {
//				$('.chk-search-status input[type=checkbox]').prop('checked', true);
//			}
			
			this.loadContracts();
		}.bind(this));
	}
	
}

